<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Plugin\Api42\Security\Core\Encoder;

use Eccube\Security\Core\Encoder\PasswordEncoder;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Security\Core\User\UserInterface;

class UserPasswordEncoder implements UserPasswordEncoderInterface
{
    /**
     * @var PasswordEncoder
     */
    private $passwordEncoder;

    /**
     * UserPasswordEncoder constructor.
     * @param PasswordEncoder $passwordEncoder
     */
    public function __construct(PasswordEncoder $passwordEncoder)
    {
        $this->passwordEncoder = $passwordEncoder;
    }

    /**
     * {@inheritdoc}
     */
    public function encodePassword(UserInterface $user, $plainPassword)
    {
        return $this->passwordEncoder->encodePassword($plainPassword, $user->getSalt());
    }

    /**
     * {@inheritdoc}
     */
    public function isPasswordValid(UserInterface $user, $raw)
    {
        return $this->passwordEncoder->isPasswordValid($user->getPassword(), $raw, $user->getSalt());

    }

    /**
     * @inheritDoc
     */
    public function needsRehash(UserInterface $user): bool
    {
        // TODO: Implement needsRehash() method.
    }
}
