<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Plugin\Securitychecker42\Repository;

use Eccube\Repository\AbstractRepository;
use Plugin\Securitychecker42\Entity\Config;
use Doctrine\Persistence\ManagerRegistry; 

/**
 * ConfigRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class ConfigRepository extends AbstractRepository
{
    /**
     * @param ManagerRegistry $registry
     */
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Config::class);
    }

    /**
     * チェック結果を保存します.
     *
     * @param string $checkResult チェック結果の JSON 文字列
     */
    public function saveCheckResult($checkResult)
    {
        /** @var Config $Config */
        $Config = $this->findOneBy(['id' => Config::DEFAULT_ID]);

        if (!$Config) {
            $Config = new Config();
            $Config->setCheckResult($checkResult);
            $this->getEntityManager()->persist($Config);
        } else {
            $Config->setCheckResult($checkResult);
        }
        $this->getEntityManager()->flush($Config);
    }

    /**
     * 前回のチェック結果を取得します.
     *
     * @return array チェック結果の連想配列
     */
    public function getCheckResult()
    {
        /** @var Config $Config */
        $Config = $this->findOneBy(['id' => Config::DEFAULT_ID]);

        if (!$Config) {
            return [];
        }

        return json_decode($Config->getCheckResult(), true);
    }
}
